           case     ON

           keep     help
           mcopy    help.mac

           copy     2/ainclude/e16.gsos
           copy     2/ainclude/e16.window
           copy     2/ainclude/e16.control
           copy     2/ainclude/e16.event
           copy     2/ainclude/e16.resources
           copy     e16.genesys
; ____________________________________________________________________
;|                                                                    |
;| 4/18/90 - MWW - All event handling is now handled via the shells   |
;|           event loop.  Save resIO reworked - now deletes the help  |
;|           res ($5751/1) and saves the handle returned by TE.  Null |
;|           helphan tests blown away in dohelp - res is released and |
;|           reloaded every time the window is closed or opened.      |
;| 4/14/90 - MWW - installHelp moved to the shell and eliminated here |
;|           as was killHelp.  Added resfile access sanity around the |
;|           doHelp and doHelpEvent calls to preserve the res world.  |
;|           Increased the TE and Wind rects to eliminate mid-line    |
;|           clipping.  Now the resource is released upon close.      |
;|           Added key translation support for pretty text access.    |
;|           -------------------------------------------------------- |
;| 4/14/90 - B1.5 - Help.Topics is now a resource file in Gen.Help    |
;|           the file is opened at run time.  killHelp is no longer   |
;|           needed - ***REMOVE killHelp from this file***            |
;| 4/13/90 - resource on Genesys file is opened as read only!         |
;|           what a pain...                                           |
;| 4/12/90 - completely changed Help to use resourced Help.Txt in an  |
;|           effort to eliminate GS/OS errors with file loading!      |
;| 4/11/90 - version B1.0 shipped!                                    |
;| 4/10/90 - 'option' left/right arrow feature added!                 |
;| 4/08/90 - added file save button and support                       |
;| 4/07/90 - tidy up                                                  |
;| 4/06/90 - search routine coded                                     |
;| 4/05/90 - requires no input to routines (directly linked to Shell) |
;| 4/04/90 - popup from Help.Txt, expanded TextEdit to fill window    |
;| 3/28/90                                                            |
;| 3/10/90 - he's got the batton and he's off and running....         |
;|                                                                    |
;| We will use the Shell's memory ID to get the memory we need.       |
;|____________________________________________________________________|
;|                                                                    |
;| This version only supports 1 HelpFile, I will include the ability  |
;| to load multiple files later (with preference given to Help.Txt)   |
;|____________________________________________________________________|
;|                                                                    |
;| 3 entry points:                                                    |
;|                                                                    |
;| Notes:                                                             |
;|                                                                    |
;| No input/output                                                    |
;| uses Shell's SMURF for needed data                                 |
;|                                                                    |
;| 1) installData - call at Genesys starup time: opens the            |
;|    Help.Topics resource file in Gen.Help                           |
;|                                                                    |
;| 2) doHelp - call when a Help menu item is chosen                   |
;|                                                                    |
;| 3) doHelpEvent - call if the Help window needs to recieve events   |
;|____________________________________________________________________|
;|                                                                    |
;| The Help.Txt file must be constructed like:                        |
;|                                                                    |
;| MenuString - for Popup control.  Item IDs begin at #10000          |
;|                                                                    |
;| following the menu string the Help entries are formated as:        |
;|                                                                    |
;| ~1xxxxW5752~                         ID/flag/type                  |
;| 'help for Root Window'                                             |
;|                                      ID - menuitem ID in ASCII     |
;| ~1xxxxR8001~                         flag - (W)indow or (R)esource |
;| 'help for rIcon editor'              type - of window or resource  |
;|                                                                    |
;| ~                                    the last character in the     |
;|                                      file must be a '~'            |
;|____________________________________________________________________|
;|                                                                    |
;| The first entry MUST be ~10000W0000~ the default Clip!!            |
;|____________________________________________________________________|

tempAsmPtr gequ     1                   used by doHelp and LoadFile

;|====================================================================|
;| doHelp - called from a Help menuitem hit                           |
;|                                                                    |
;| Looks for the FrontWindow and tries to locate a Help Clip that is  |
;| appropriate - ie. Context Sensitive Help!!                         |
;|                                                                    |
;|====================================================================|

doHelp     Start

           using      Shell
;_Window Kind equates____________________________

Editor     equ      $0000
SubEditor  equ      $0001
ObjectEditor equ    $0002
Palette    equ      $5750               PW (backwards)
Help       equ      $5751               QW
Root       equ      $5752               RW
SourceText equ      $5754               TW

           phb
           phd
           phk
           plb

           pha                          space for tempAsmPtr
           pha

           tsc
           tcd                          align stack and DP

           PushWord #0
           _GetCurResourceFile
           PullWord CurResID

           PushWord GenDataID
           _SetCurResourceFile

           PushWord #0
           PushWord #-1
           _SetResourceFileDepth
           PullWord CurDepth

           lda      HelpWinPtr          window already open?
           ora      HelpWinPtr+2        br = no
           beq      DoOpenWin

           PushLong HelpWinPtr          yes, so bring it up front!
           _SelectWindow

           brl      doHelpOut           BORING (I never get to do nothin)

;_Lot's of work to do!________________________________________________

DoOpenWin  anop

           _WaitCursor

           PushLong #0000
           PushWord #$5751
           PushLong #$00000001
           _LoadResource
           bcc      GoodLoad

           _InitCursor

           ply
           ply
           ldx      #$6002
           jsl      shError2
           brl      doHelpOut

GoodLoad   anop

           _InitCursor

           PullLong HelpHan             retrieve handle

           PushLong #0000               lock & dereference
           PushLong HelpHan
           jsl      Deref
           PullLong HelpPtr

           PushLong #0000
           PushLong HelpHan
           _GetHandleSize
           PullLong HelpLen
           bcc      ReadyToGo

           ldx      #$6004
           jsl      shError2
           brl      doHelpOut


ReadyToGo  anop

           jsl      makeMenuPtr         pull out menu string pointer

;_Do context sensitive Help___________________________________________

           PushLong #0000               for Deref
           PushLong #0000               for GetWRefCon

           PushLong #0000
           _FrontWindow
           lda      1,s                 NULL?
           ora      3,s
           bne      aWin                br = nope, a valid window up front!

;_An empty DeskTop - so display the 'Help' help_______________________

           pla
           pla

noRefCon   anop                         entry point if no winRefCon

           pla
           pla
           pla
           pla                          clean up stack

defaultHelp anop                        enter here for 'Help' help!

           lda      #0
           ldx      #1                  search for window type (W)
           jsl      setSearchStr        setup the searchStr
           jsl      findFirstLast       find 1st/last offsets to Help clip

           bcc      cw                  no err

; we gots a problem if we get here!!!

           lda      #$FFFF
           ldx      #$6000
           jsl      shError2
           brl      doHelpOut

cw         anop

           sta      whichItem
           brl      createWindow        and show it

;_Got a window - so case it___________________________________________

aWin       anop

           _GetWRefCon
           lda      1,s                 NULL?
           ora      3,s
           beq      noRefCon            br = no refCon

aRefCon    anop

           jsl      Deref
           PullLong <tempAsmPtr         get winInfo stuff

           ldy      #06                 get winKind field
           lda      [<tempAsmPtr],y

           cmp      #Root               root window?
           bne      notRoot

;_find 'Root Window' Help_____________________________________________

           lda      #Root
           ldx      #1                  search for window type (W)
           jsl      setSearchStr        setup the searchStr
           jsl      findFirstLast       find 1st/last offsets to Help clip

           bcc      gotRoot
           brl      defaultHelp         do default clip

gotRoot    anop

           sta      whichItem
           brl      createWindow        and show it

notRoot    anop

           cmp      #Editor
           bne      notEditor
           brl      doResType           search for res type

notEditor  anop

           cmp      #SubEditor
           bne      notSub
           brl      doResType           search for res type

notSub     anop

           cmp      #ObjectEditor
           bne      notObject
           brl      doResType           search for res type

notObject  anop

           cmp      #SourceText
           bne      doResType

           lda      #SourceText
           ldx      #1                  search for window type (W)
           jsl      setSearchStr        setup the searchStr
           jsl      findFirstLast       find 1st/last offsets to Help clip

           bcc      gotSource
           brl      defaultHelp

gotSource  anop

           sta      whichItem
           brl      createWindow        br = unrecognized window

doResType  anop

           ldy      #00                 winResType field
           lda      [<tempAsmPtr],y
           ldx      #2                  search for window type (W)
           jsl      setSearchStr        setup the searchStr
           jsl      findFirstLast       find 1st/last offsets to Help clip

           bcc      gotResType
           brl      defaultHelp

gotResType anop

           sta      whichItem

;_Actually create the window here_____________________________________

createWindow anop

           lda      SMURF+wmModifiers
           and      #optionKey
           beq      readOnly

           lda      #$FFFF              set winMode

readOnly   anop

           sta      winMode

           PushLong #0000               space
           PushLong #0000               titlePtr
           PushLong #hwRefConHan        refCon
           PushLong #DrawHelpProc       contentDrawProc
           PushLong #0000               defProcPtr
           PushWord #00                 paramTableDesc
           PushLong #HelpParms          pointer to window template
           PushWord #$800E              rWindParam1
           _NewWindow2
           PullLong HelpWinPtr

           PushLong HelpWinPtr
           _SetPort

           MoveLong HelpPtr,ClipOffset  set TextEdit fields
           MoveLong HelpLen,ClipLen

           lda      winMode
           beq      modeRead

modeEdit   anop                         'super user' editing mode

           lda      editFlags+2
           sta      modeFlags+2
           lda      editFlags
           sta      modeFlags

           PushLong #0000               create the save button
           PushLong HelpWinPtr
           PushWord #00
           PushLong #saveCtl
           _NewControl2
           PullLong saveCtlHan          save handle

           bra      createTextEdit

modeRead   anop                         yuchy 'read only' mode

           lda      viewFlags+2
           sta      modeFlags+2
           lda      viewFlags
           sta      modeFlags

           jsl      setClip             set pointer and length of Clip

createTextEdit anop

           PushLong #0000               create the TextEdit control
           PushLong HelpWinPtr
           PushWord #00
           PushLong #textEdCtl
           _NewControl2
           PullLong textCtlHan          save handle

           PushLong #0000               create the PopUp control
           PushLong HelpWinPtr
           PushWord #00
           PushLong #popupCtl
           _NewControl2
           PullLong popupCtlHan         save handle

doHelpOut  anop

           PushWord CurResID
           _SetCurResourceFile

           PushWord #0
           PushWord CurDepth
           _SetResourceFileDepth
           pla

           pla
           pla
           pld
           plb

           lda      #00                 no error
           rtl

closeHelpWin ENTRY
*****************************************************************
*
*   closeHelpWin is called from doExit to close the help window
*
*****************************************************************
*
           phb
           phd
           phk
           plb

           PushLong HelpWinPtr          close the window
           _CloseWindow

           stz      HelpWinPtr+2
           stz      HelpWinPtr

           lda      MenuStrHan
           ora      MenuStrHan+2
           beq      noMenuHan

           PushLong MenuStrHan
           _DisposeHandle

           PushWord #-1
           PushWord GenDataID
           jsl      SetResAccess

noMenuHan  PushWord #-1
           PushWord #$5751
           PushLong #1
           _ReleaseResource

           PushWord #-1
           PushWord GenFileID
           jsl      SetResAccess

           pld
           plb
           RTL

doHelpKey  ENTRY
*****************************************************************
*
*   doHelpKey is called from the new shell doKey function
*
*****************************************************************
*
           phb
           phd
           phk
           plb

           lda      SMURF+wmModifiers
           and      #optionKey
           beq      noOption

           PushWord #00
           PushLong popupCtlHan
           _GetCtlValue
           plx

           lda      SMURF+wmMessage
           and      #$FF                clear high byte
           cmp      #$08                left arrow?
           bne      checkRight

           cpx      FirstMItem          do left arrow (go back 1 Clip)
           beq      noOption

           dex
           bra      doArrow

checkRight cmp      #$15                right arrow?
           bne      noOption

           cpx      LastMItem           do right arrow (go forward 1 Clip)
           bcs      noOption            at last one already

           inx

doArrow    phx                          save a copy
           phx                          set it
           PushLong popupCtlHan
           _SetCtlValue

           pla
           ldx      #0                  search for itemID
           jsl      setSearchStr        setup the searchStr
           jsl      findFirstLast       find 1st/last offsets to Help clip
           jsl      setClip

           PushWord #$0005
           PushLong ClipOffset
           PushLong ClipLen
           PushWord #00                 styleDescriptor
           PushLong #0000               styleRef
           PushLong textCtlHan
           _TESetText

noOption   pld
           plb
           RTL

doHelpCtrl ENTRY
*****************************************************************
*
*   doHelpKey is called from the new shell doKey function
*
*****************************************************************
*
           phb
           phd
           phk
           plb

           lda      SMURF+wmTaskData4
           cmp      #$1002              popup control?
           bne      trySave

           PushWord #00
           PushLong popupCtlHan
           _GetCtlValue
           pla
           cmp      #10000              valid for here?
           bcs      doPopup

           brl      endCtrl

doPopup    ldx      #0                  search for itemID in accumulator
           jsl      setSearchStr        setup the searchStr
           jsl      findFirstLast       find 1st/last offsets to Help clip
           jsl      setClip

           PushWord #$0005
           PushLong ClipOffset
           PushLong ClipLen
           PushWord #00                 styleDescriptor
           PushLong #0000               styleRef
           PushLong textCtlHan
           _TESetText

           brl      endCtrl

trySave    cmp      #$1003              save control?
           bne      endCtrl

           jsl      saveTheHelp

endCtrl    pld                          restore data bank register
           plb                          restore direct page register

           lda      #00                 no error
           rtl

;|====================================================================|
;| Support routines                                                   |
;|====================================================================|

; ____________________________________________________________________
;|                                                                    |
;| makeMenuPtr - pull out the menu string from the Help.Txt file      |
;|               and set menuPtr to this new pointer                  |
;|                                                                    |
;|               *** Requires a valid Help.Ptr ***                    |
;|                                                                    |
;| Creates a menuHan which needs to be destroyed when the window is   |
;| closed. Also sets FirstMItem & LastMItem.                          |
;|                                                                    |
;| This routine is really only need when the Help system is in        |
;| 'Super User' mode (ie editing).  The MenuMgr actually changes      |
;| the menu string in the Help.Txt file and it shows up as garbage    |
;| on the screen.                                                     |
;|____________________________________________________________________|

makeMenuPtr entry

           phd
           pha
           pha
           tsc
           tcd

           MoveLong HelpPtr,tempAsmPtr

; find FirstMItem

           ldy      #0
           bra      fi1

find1stItem anop

           iny

fi1        lda      [<tempAsmPtr],y
           cmp      #$4E5C              find '\N'
           bne      find1stItem

           iny
           iny

           tya
           clc
           adc      tempAsmPtr
           tax
           lda      #0
           adc      tempAsmPtr+2

           pha                          space (the final frontier)
           pha
           phx
           PushWord #5
           PushWord #0                  unsigned
           _Dec2Int
           pla
           sta      FirstMItem

           SHORTM                       find the 1st '~' in the file
           ldy      #0                  ASSUMES there is at least 1 at end of
           bra      ft1                 menu string!!!

find1stTilde anop

           iny
ft1        lda      [<tempAsmPtr],y
           cmp      #'~'
           bne      find1stTilde        'y' has length of menu string

foundTilde anop

           LONGM

           iny
           sty      tempLen
           stz      tempLen+2

           dey
           bra      fli1

findLastItem anop

           dey

fli1       lda      [<tempAsmPtr],y
           cmp      #$4E5C              find '\N'
           bne      findLastItem

           iny
           iny

           tya
           clc
           adc      tempAsmPtr
           tax
           lda      #0
           adc      tempAsmPtr+2

           pha
           pha
           phx
           PushWord #5
           PushWord #0                  unsigned
           _Dec2Int
           pla
           sta      LastMItem

           PushLong #0000               get a handle for the menu string
           PushLong tempLen
           lda      SMURF+ShellID
           pha
           PushWord #$C018              attrs Locked, Fixed, NoCross & NoSpec
           PushLong #0000
           _NewHandle
           bcc      gmh1

           ldx      #$6102
           jsl      shError2

gmh1       anop

           PullLong MenuStrHan

           PushLong HelpPtr
           PushLong MenuStrHan
           PushLong tempLen
           _PtrToHand                   set handle to menu string
           bcc      gpt1

           ldx      #$6104
           jsl      shError2

gpt1       anop

           PushLong #0000
           PushLong MenuStrHan
           jsl      Deref
           PullLong menuPtr             what we want!

           plx
           plx
           pld

           rtl

tempLen    ds       4

; ____________________________________________________________________
;|                                                                    |
;| setSearchStr - sets the 'searchStr' for the required clip          |
;|                                                                    |
;| x = 0 - search for item ID ($0)                                    |
;| x = 1 - search for winKind (W)                                     |
;| x = 2 - search for resType (R)                                     |
;|                                                                    |
;| a - ID of type to search for                                       |
;|____________________________________________________________________|
;|                                                                    |
;| See Help file construction above                                   |
;|____________________________________________________________________|

setSearchStr entry

           sta      tempID              keep it

           cpx      #0
           bne      look4Win            not it, try window search

;_setup for item ID search____________________________________________

           stz      kindFlag            trashes byte of kindID but so what!

           PushWord tempID
           PushLong #menuID
           PushWord #5                  5 dec characters
           PushWord #0                  not signed
           _Int2Dec                     convert ID to ASCII string
           bcc      gid

           ldx      #$6202
           jsl      shError2

gid        anop

           stz      kindID+2
           stz      kindID

           brl      out

look4Win   anop

           cpx      #1
           bne      look4Res            not it, try resType search

;_setup for window kind search________________________________________

           SHORTX
           ldx      #'W'                find a window kind
           stx      kindFlag
           LONGX
           bra      hexIt

;_setup for resource type search______________________________________

look4Res   anop

           SHORTX
           ldx      #'R'                find a resource type
           stx      kindFlag
           LONGX

hexIt      anop

           PushWord tempID
           PushLong #kindID
           PushWord #4                  4 hex characters
           _Int2Hex                     convert ID to ASCII string
           bcc      hi1

           ldx      #$6204
           jsl      shError2

hi1        anop

           stz      menuID+3
           stz      menuID+2
           stz      menuID

out        anop

           rtl

tempID     ds       2

; ____________________________________________________________________
;|                                                                    |
;| findFirstLast - find the first and last offsets for the clip       |
;|                 and return on the stack                            |
;|                                                                    |
;| uses HelpPtr, HelpLen & searchStr                                  |
;|                                                                    |
;| sets startOffset and lastOffset                                    |
;|                                                                    |
;| returns mItemID in a   *** NOT NEEDED ***                          |
;|                                                                    |
;| c = 0 no err   = 1 an err                                          |
;|____________________________________________________________________|

findFirstLast entry

           phd
           pha
           pha
           tsc
           tcd

           lda      HelpPtr+2           set ptr to Help text
           sta      tempAsmPtr+2
           lda      HelpPtr
           sta      tempAsmPtr

           lda      searchStr
           and      #$00FF
           inc      a
           sta      checkX              length byte of search string

           SHORTM
           ldy      #0
           ldx      #1
           bra      ff1

findFirst  anop

           iny

ff1        cpy      HelpLen
           bcc      ff2
           brl      atEOF

ff2        lda      [<tempAsmPtr],y
           cmp      searchStr,x
           bne      findFirst

checkStr   anop

           inx
           cpx      checkX              length byte
           bcc      cs1
           brl      foundStr            got it!

cs1        iny
           cpy      HelpLen
           bcc      cs2
           brl      atEOF

cs2        lda      searchStr,x
           beq      checkStr            br = wild card char

           cmp      [<tempAsmPtr],y
           beq      checkStr
           ldx      #1                  reset x counter
           brl      findFirst

;_Got me a string!____________________________________________________

foundStr   anop

           LONGM
           iny
           sty      startOffset
           stz      startOffset+2       limit it to 64K

           SHORTM
           bra      fl1

findLast   anop                         find the trailing '~'

           iny
           cpy      HelpLen
           bcc      fl1
           brl      atEOF

fl1        lda      [<tempAsmPtr],y
           cmp      searchStr+1
           bne      findLast

;_got it!_____________________________________________________________

gotIt      anop

           LONGM
           sty      lastOffset
           stz      lastOffset+2

           lda      startOffset         now get the mItemID
           sec
           sbc      #11
           clc
           adc      HelpPtr
           sta      tempAsmPtr
           lda      #0
           adc      HelpPtr+2
           sta      tempAsmPtr+2

           PushWord #00
           PushLong tempAsmPtr
           PushWord #5
           PushWord #0                  unsigned
           _Dec2Int
           bcc      pop1

           ldx      #$6302
           jsl      shError2

pop1       anop

           pla
           clc

popop      anop

           plx
           plx
           pld

           rtl

atEOF      anop

           LONGM
           sec
           lda      #00
           bra      popop

checkX     ds       2

; ____________________________________________________________________
;|                                                                    |
;| setClip - sets the TextEdit text to the Help clip who's offsets    |
;|           are in startOffset & lastOffset                          |
;|____________________________________________________________________|

setClip    entry                        set the Help clip

           lda      HelpPtr
           clc
           adc      startOffset
           sta      ClipOffset
           lda      #0
           adc      HelpPtr+2
           sta      ClipOffset+2

           lda      lastOffset
           sec
           sbc      startOffset
           sta      ClipLen
           lda      lastOffset+2
           sbc      startOffset+2
           sta      ClipLen+2

           rtl

; ____________________________________________________________________
;|                                                                    |
;| DrawHelpProc - draw the HelpWindow                                 |
;|____________________________________________________________________|

DrawHelpProc anop

           phb
           phd
           phk
           plb

           PushLong #0000
           _GetPort
           _DrawControls

           pld
           plb
           rtl

; _______________________________________________
;|                                               |
;| Deref - dereference a handle, lock it and     |
;|         return the pointer on the stack.      |
;|                                               |
;| call as:         PushLong  #0000              |
;|                  PushLong  theHandle          |
;|                  JSL       Deref              |
;|                  PullLong  thePointer         |
;|                                               |
;| 10/26/88 07:00  Michael L. J. Hackney         |
;|_______________________________________________|
;|                                               |
;| updates:                                      |
;|                                               |
;| 04/21/89 - lock handle added                  |
;|_______________________________________________|

Deref      entry

;_Stack/Direct Page offsets______________________

OrigD      equ      1
OrigB      equ      OrigD+2
RtnAddr    equ      OrigB+1
theHandle  equ      RtnAddr+3
ReturnVal  equ      theHandle+4

           phb
           phd

           tsc
           tcd                          ; align stack and DP

           ldy      #4                  ; lock it
           lda      [theHandle],y
           ora      #$8000
           sta      [theHandle],y       ; and save locked


           lda      [theHandle]
           sta      <ReturnVal          ; keep pointer on stack

           ldy      #02
           lda      [theHandle],y
           sta      <ReturnVal+2        ; keep pointer on stack

           lda      <RtnAddr            ; move return address up
           sta      <ReturnVal-3
           lda      <RtnAddr+1
           sta      <ReturnVal-2

           tsc                          ; get stack pointer

           pld                          ; restore data bank register
           plb                          ; restore direct page register

           clc                          ; adjust the stack pointer
           adc      #ReturnVal-4
           tcs                          ; reset stack pointer

           rtl

; ____________________________________________________________________
;|                                                                    |
;| saveTheHelp - save the help file                                   |
;|____________________________________________________________________|

saveTheHelp entry

           phd

           PushLong #0000               get a handle for the text
           PushLong #0001
           lda      SMURF+ShellID
           pha
           PushWord #$0018              attrNoCross & attrNoSpec
           PushLong #0000
           _NewHandle                   get mem for file
           bcc      gotTheHan

           ldx      #$6402
           jsl      shError2

           pla
           pla
           brl      cleanUpNEnd

gotTheHan  anop

           PullLong tempHan

           PushLong #0000               get the text
           PushWord #$000D              pass a handle
           PushLong tempHan
           PushLong #0000               length - ignored
           PushWord #00
           PushLong #0000
           PushLong textCtlHan
           _TEGetText
           bcc      gotTheText

           ply
           ply
           ldx      #$6404
           jsl      shError2
           brl      cleanUpNEnd

gotTheText anop

           PullLong TextLength          wbrequestCount

           PushLong tempHan
           _HLock

           PushWord #0
           _GetCurResourceFile
           PullWord CurResID

           PushWord GenDataID
           _SetCurResourceFile

           PushWord #0
           PushWord #1
           _SetResourceFileDepth
           PullWord CurDepth

           PushWord #-1
           PushWord #$5751
           PushLong #1
           _ReleaseResource
           ldx      #$6410
           jsl      shError2

           PushWord #$5751
           PushLong #1
           _RemoveResource
           ldx      #$6412
           jsl      shError2

           stz      HelpHan
           stz      HelpHan+2

           PushLong tempHan
           PushWord #$8018
           PushWord #$5751
           PushLong #1
           _AddResource
           ldx      #$6414
           jsl      shError2

           PushWord #$5751
           PushLong #1
           _WriteResource
           ldx      #$6416
           jsl      shError2

           jsl      closeHelpWin

           PushLong tempHan
           _DisposeHandle
           ldx      #$6418
           jsl      shError2

cleanUpNEnd anop
           pld                          old DP

           rtl                          and GO HOME!!!

tempHan    ds       4                   keep the handle here for a sec
TextLength ds       4

; ____________________________________________________________________
;
;_data_______________________________________________________________

HelpHan    ds       4                   Help.Txt han
HelpPtr    ds       4                      "     ptr
HelpLen    ds       4                   length of file

CurResID   ds       2
CurDepth   ds       2

startOffset ds      4
lastOffset  ds      4

MenuStrHan ds       4                   menu string (removed from Help.Txt)
FirstMItem ds       2
LastMItem  ds       2

textCtlHan  ds      4                   handle to TextEdit control
popupCtlHan ds      4                   handle to PopUp control
saveCtlHan  ds      4                   handle to Save button control

; the search string - $0 is a wildcard char

searchStr  dc       h'0C'
           dc       c'~'
menuID     dc       c'xxxxx'
kindFlag   dc       c'Z'
kindID     dc       c'xxxx'
           dc       c'~'

;_Window Template____________________________________________________

HelpParms  anop

           dc       i2'HelpEnd-HelpParms'
           dc       i2'fTitle+fClose+fMove+fVis+fCtlTie'
           dc       i4'HelpTitleStr'
RefCon     dc       i4'hwRefConHan'
           dc       i2'30, 50, 171, 590'
           dc       i4'00'
           dc       i2'0'
           dc       i2'0'
           dc       i2'0'
           dc       i2'0'
           dc       i2'0'
           dc       i2'0'
           dc       i2'0'
           dc       i2'0'
           dc       i2'0'
           dc       i2'0'
           dc       i4'00'
           dc       i2'0'
           dc       i4'00'
           dc       i4'00'
           dc       i4'DrawHelpProc'
           dc       i2'30, 50, 171, 590'
           dc       i4'-1'
           dc       i4'00'
           dc       i2'00'
HelpEnd    anop

HelpTitleStr STR    ' Genesys Help '

;_Help Window RefCon - do not use DisposeHandle on this!!!____________

hwRefConHan  dc     i4'hwRefConPtr'
hwRefConPtr  dc     i2'0'
             dc     i4'00'
             dc     i2'$5751'           QW
             dc     i4'00'
winMode      dc     i2'00'              = 0 / view, = -1 / edit

;_TextEdit Control Template___________________________________________

textEdCtl  anop                         textedit control template
           dc       i2'23'              fill it up!!
           dc       i4'$00001001'       ID
           dc       i2'17, 4, 139, 536' rect
           dc       i4'$85000000'       procRef
           dc       i2'0'               flag
           dc       i2'$7400'           moreFlags
           dc       i4'00'              refCon
modeFlags  dc       i4'$46B00000'       textFlags
           dc       i2'-1, -1, -1, -1'  indentRect
           dc       i4'-1'              vertBar
           dc       i2'0'               vertAmount
           dc       i4'0'               horzBar - must be NIL
           dc       i2'0'               horzAmount - must be zero
           dc       i4'00'              styleRef
           dc       i2'5'               textDescriptor
ClipOffset ds       4                   textRef
ClipLen    ds       4                   textLength
           dc       i4'00'              maxChars
           dc       i4'00'              maxLines - must be 0
           dc       i2'0'               maxCharsPerLines - must be 0
           dc       i2'0'               maxHeight - must be 0
           dc       i4'00'              colorRef
           dc       i2'0'               drawMode
           dc       i4'00'              filterProcPtr

viewFlags  dc       i4'$46B00000'
editFlags  dc       i4'$42800000'

;_Popup Control Template______________________________________________

popupCtl   anop

           dc       i2'9'               pCount
           dc       i4'$00001002'       ID
           dc       i2'2, 4, 0, 0'      rect
           dc       i4'$87000000'       procRef
           dc       i2'00'              flag
           dc       i2'$1004'           moreFlags - ptr to text stream
teRefCon   dc       i4'0000'            refCon
           dc       i2'00'              titleWidth
menuPtr    ds       4                   menuRef
whichItem  dc       i2'10000'           initialValue - filled in at run time

;_Save Button Control Template________________________________________

saveCtl    anop

           dc       i2'7'               pCount
           dc       i4'$00001003'       ID
           dc       i2'2, 450, 15, 536' rect
           dc       i4'$80000000'       procRef
           dc       i2'$0'              flag
           dc       i2'$1000'           moreFlags
           dc       i4'0000'            refCon
           dc       i4'SaveStr'         titleRef

SaveStr    STR      'Save'

           END
